import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.properties.*;

ArrayList<String> getKeywords(XMPMeta meta) {
	XMPProperty p;
	var keywords = [];
	int i = 1;
	for (; (p = meta.getArrayItem("http://ns.acdsee.com/iptc/1.0/", "acdsee:keywords", i)) != null; i++) {
	   String keyword = p.getValue().trim();
	   if (keyword.length() > 0) {
	       keywords.add(keyword);
	   }
	}
	return keywords;
}

//-------------

Work.on(TreeCollection.of(selectedObjects).parallelStream().filter(ao -> ao.xmpManager != null))
.titled("Import ACDSee metadata")
.inform("This script imports ACDSee metadata as standard  xmp metadata")
.forEach(ao) -> {
	XmpManager mgr = ao.getXmpManager();
	Set existing = mgr.getKeywordSet();

	existing.addAll(getKeywords(mgr.XMPMeta));
	mgr.keywords = existing.toArray(String[]::new);
	mgr.save();
}
.execute(work) -> {
	// Refresh display
	explorer.context.viewFolder(explorer.context.currentFolder);
	window.statusBar.setText("Processed ${work.processed} objects");
}
.showResult();
